package gov.va.med.mhv.vitals.repository;

import gov.va.med.mhv.vitals.model.PulseOximetryReading;

import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface PulseOximetryReadingRepository extends JpaRepository<PulseOximetryReading, Long> {
	
     @Query("select a from PulseOximetryReading a where a.userprofileId = :userprofileid order by a.reading desc")
	 List<PulseOximetryReading>  getPulseOximetryReadingsForUser(@Param ("userprofileid") Long userprofileid);
     
     
     @Query("select a from PulseOximetryReading a where a.userprofileId = :userprofileid order by a.reading desc")
	 List<PulseOximetryReading>  getDashBoardPulseOximetryReadingsForUser(@Param ("userprofileid") Long userprofileid,Pageable page);



}
